Attribute VB_Name = "Quotation"
Option Explicit

Global Const QUOTATION_SYSTEM_CODE As String = "2"
Global Const TOPBOTTOMPAGE_CODEHEADER As String = "0"
Global Const TOPBOTTOMPAGE_CODEFOOTER As String = "1"

Global gi_QuotationCode As Integer
Global gs_QuotationDesc As String
Global gi_QuotationVersion As Integer
Global gi_QuotationStatusCode As Integer
Global gs_QuotationStatusDesc As String
Global gs_QuotationLanguageCode As String
Global gs_QuotationPlantCode As String
Global gs_QuotationPlantDesc As String

Global gl_OldHwndQuotationGeneralView As Long
Global gl_OldHwndQuotationLineView As Long
Global gl_OldHwndQuotationCustomerView As Long
Global gl_OldHwndQuotationSalesProjectView As Long

Public Enum Quotation_Status
    None = 0
    opened = 1
    Waiting_Plant_Confirmation = 2
    Send_to_customer = 3
    Refused_Notify_customer = 4
    closed = 5
    Waiting_Customer_Confirmation = 6
    Old_Version = 7
    Enter_customer_order = 8
    Ordered_to_plant = 9
    Archived = 10
    Customer_changes_Quotation = 11
End Enum

Private mi_QuotationMaxVersion As Integer
Private mb_QuotationChange As Boolean
Private mb_QuotationLoad As Boolean

Private mi_View As Integer

Private mb_StatusListLoaded As Boolean
Private mo_StatusListCode As New Collection
Private mo_StatusListLang As New Collection
Private mo_StatusListDesc As New Collection
Private mo_StatusListAltDesc As New Collection
Private mb_NextStatusListLoaded As Boolean
Private mo_NextStatusListCodeParent As New Collection
Private mo_NextStatusListCodeChild As New Collection


'------------------------------------------------------------------
' Name : Quotation_Change
'
' Purpose : Execute when the outline indicates that the quotation
'           has change. Change the code and description in the
'           global variables to indicate the new quotation code.
'
' Parameters :
'       ls_QuotCode   Quotation Identifier
'       ls_QuotDesc   Quotation Description (User code)
'       li_Left       Indicates the left position of the view
'       li_Top        Indicates the top position of the view
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Sub Quotation_Change(ls_QuotCode As String, ls_Quotdesc As String, li_Left As Integer, li_top As Integer, Optional li_View)
Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long

    On Error GoTo Quotation_Change_Err
    
    
    gi_QuotationCode = CInt(ls_QuotCode)
    gs_QuotationDesc = CStr(ls_Quotdesc)

    'Read the actual version number (the last version)
    ls_Req = "exec quotation_sel2 " & ls_QuotCode
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        ' Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                mi_QuotationMaxVersion = Formatage2(ODBCDataInt(ll_Statement, 1))
            End If
        Loop
    
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
        
        gi_QuotationVersion = mi_QuotationMaxVersion
    
        mb_QuotationChange = OK
    
        If IsMissing(li_View) Then
            frmMain.QuotationOutLine.ChangeView mi_View
            Quotation_ChangeView mi_View, li_Left, li_top
        Else
            frmMain.QuotationOutLine.ChangeView li_View
            mi_View = li_View
            'Quotation_ChangeView li_View, li_Left, li_top
        End If
    
    End If
    
    Exit Sub
    
Quotation_Change_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    
End Sub

'------------------------------------------------------------------
' Name : Quotation_Refresh
'
' Purpose : Force the refresh of the quotation
'
'
' review : Oct/29/1999 by AD
'------------------------------------------------------------------
Public Sub Quotation_Refresh(ByRef lo_txt_QuotationStatus As TextBox, ByRef lo_cbo_QuotationVersion As ComboBox, ByVal li_Left As Integer, ByVal li_top As Integer)
    
    
    'Update the common part
    mb_QuotationChange = OK
    Quotation_UpdateCommonInformation lo_txt_QuotationStatus, lo_cbo_QuotationVersion
    
    frmMain.QuotationOutLine.LocalDelItem gi_QuotationCode
    frmMain.QuotationOutLine.LocalAddItem gi_QuotationCode, gs_QuotationDesc
    
    'Quotation_ChangeView mi_View, li_Left, li_top
    'Quotation_Change CStr(gi_QuotationCode), gs_QuotationDesc, li_Left, li_top
    ' FrmMain.QuotationOutLine.SearchOutline gi_QuotationCode

End Sub

'------------------------------------------------------------------
' Name : Quotation_UpdateCommonInformation
'
' Purpose : Update all the common informations with the quotation
'           code. This procedure is call when the user change the
'           version or when the user call a view. This procedure
'           update the information only if it is a new version or
'           a new quotation
'
' Parameters :
'       lo_Cbo_QuotationVersion  The ComboBox which stock the version number
'
' Return :
'       OK      The information have been updated
'       KO      The information havn't be updated
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_UpdateCommonInformation(ByRef lo_txt_QuotationStatusDesc As TextBox, ByRef lo_cbo_QuotationVersion As ComboBox) As Boolean
Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim li_version As Integer
Dim ls_PlantCode As String

    On Error GoTo Quotation_UpdateCommonInformation_Err
    
    'Read the current version
    li_version = lo_cbo_QuotationVersion.List(lo_cbo_QuotationVersion.ListIndex)
    
    'if it's not a new version and it's not a new quotation, we exit
    If gi_QuotationVersion = li_version And mb_QuotationChange = KO Then
        'If we come from the load event, we indicates that we must load the informations
        If mb_QuotationLoad = OK Then
            Quotation_UpdateCommonInformation = OK
            mb_QuotationLoad = KO
        Else
            Quotation_UpdateCommonInformation = KO
        End If
        Exit Function
    End If
    
    'Read the status and language code
    ls_Req = "exec quotation_sel3 " & CStr(gi_QuotationCode) & "," & CStr(li_version) & ",'E'"
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        ' Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                'Update the language and status codes
                gs_QuotationDesc = ODBCData(ll_Statement, 1)
                gs_QuotationLanguageCode = ODBCData(ll_Statement, 2)
                gi_QuotationStatusCode = ODBCData(ll_Statement, 3)
                ls_PlantCode = ODBCData(ll_Statement, 4)
                If ls_PlantCode = "" Then
                    gs_QuotationPlantCode = ""
                    gs_QuotationPlantDesc = ""
                Else
                    gs_QuotationPlantCode = CStr(ls_PlantCode)
                    gs_QuotationPlantDesc = CStr(ODBCData(ll_Statement, 5))
                End If
            End If
        Loop
        'Update the version and status description
        gi_QuotationVersion = li_version
        gs_QuotationStatusDesc = Quotation_Status_Desc(gi_QuotationStatusCode, gs_QuotationLanguageCode)
    
        lo_txt_QuotationStatusDesc = gs_QuotationStatusDesc
    
        Quotation_UpdateCommonInformation = OK
    
        mb_QuotationChange = KO
    End If
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    
    Exit Function
    
Quotation_UpdateCommonInformation_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError

End Function

'------------------------------------------------------------------
' Name : Quotation_View_Load
'
' Purpose : This procedure is called when a view is loaded. This
'           procedure fill the combobox and execute the click
'           event of the combobox.
'
' Parameters :
'       lo_Txt_QuotationCode     The TextBox which stock the quotation code
'       lo_Txt_QuotationStatus   The TextBox which stock the quotation Status description
'       lo_Cbo_QuotationVersion  The ComboBox which stock the version number
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Sub Quotation_View_Load(ByRef lo_txt_QuotationCode As TextBox, ByRef lo_txt_QuotationStatus As TextBox, ByRef lo_cbo_QuotationVersion As ComboBox)
Dim i As Integer

    'Clear the version combobox
    lo_cbo_QuotationVersion.Clear
    
    'The informations of the view must be loaded
    mb_QuotationLoad = OK
    
    'Fill the version combobox and select the actual version in the list
    For i = 1 To mi_QuotationMaxVersion
        lo_cbo_QuotationVersion.AddItem CStr(i)
        If i = gi_QuotationVersion Then
            'This line call the click event of the combobox
            'If it's a new version, the informations are updated
            lo_cbo_QuotationVersion.ListIndex = lo_cbo_QuotationVersion.NewIndex
        End If
    Next
    
    'Update the text_box
    lo_txt_QuotationCode.Text = gs_QuotationDesc
    lo_txt_QuotationStatus.Text = gs_QuotationStatusDesc
    
End Sub

'------------------------------------------------------------------
' Name : Quotation_DefaultView
'
' Purpose : This procedure is called at the beginning and when we want
'           no view.
'
' Parameters : Nothing
'
' review : Oct/28/1999 by AD
'------------------------------------------------------------------
Public Sub Quotation_DefaultView()
    mi_View = frmMain.QuotationOutLine.i_DefaultView
    gl_OldHwndQuotationGeneralView = 0
    gl_OldHwndQuotationLineView = 0
    gl_OldHwndQuotationCustomerView = 0
    gl_OldHwndQuotationSalesProjectView = 0
End Sub

'------------------------------------------------------------------
' Name : Quotation_Change_View
'
' Purpose : This procedure is called when outline component indicates
'           that an other view is requiered. This procedure unload all
'           other view and load the good view.
'
' Parameters :
'       li_view     number that indicate the view to load
'       li_left     indicate the left position of the view
'       li_top      indicate the top position of the view
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Sub Quotation_ChangeView(ByVal li_View As Integer, ByVal li_Left As Integer, ByVal li_top As Integer)

    On Error GoTo Err_UnLoad
    
    If gl_OldHwndQuotationGeneralView <> 0 Then
         SetOwner Quot_General_View.hwnd, gl_OldHwndQuotationGeneralView
         gl_OldHwndQuotationGeneralView = 0
    End If
    If gl_OldHwndQuotationLineView <> 0 Then
         SetOwner Quot_Line_View.hwnd, gl_OldHwndQuotationLineView
         gl_OldHwndQuotationLineView = 0
    End If
    If gl_OldHwndQuotationCustomerView <> 0 Then
         SetOwner Quot_Customer_View.hwnd, gl_OldHwndQuotationCustomerView
         gl_OldHwndQuotationCustomerView = 0
    End If
    If gl_OldHwndQuotationSalesProjectView <> 0 Then
         SetOwner Quot_SalesProject_View.hwnd, gl_OldHwndQuotationSalesProjectView
         gl_OldHwndQuotationSalesProjectView = 0
    End If
    Unload Quot_General_View
    Unload Quot_Line_View
    Unload Quot_Customer_View
    Unload Quot_SalesProject_View

    On Error GoTo 0

    If mi_View = -1 Then
        Quotation_DefaultView
    Else
        If li_View > 0 Then
            mi_View = li_View
        Else
            Exit Sub
        End If
    End If
    
    Select Case mi_View
        Case 1
            Quot_General_View.mi_LeftForm = li_Left
            Quot_General_View.mi_TopForm = li_top
            Quot_General_View.show
            gl_OldHwndQuotationGeneralView = SetOwner(Quot_General_View.hwnd, frmMain.QuotationOutLine.l_FormHandle)
        Case 2
            Quot_Line_View.mi_LeftForm = li_Left
            Quot_Line_View.mi_TopForm = li_top
            Quot_Line_View.show
            gl_OldHwndQuotationLineView = SetOwner(Quot_Line_View.hwnd, frmMain.QuotationOutLine.l_FormHandle)
        Case 3
            Quot_Customer_View.mi_LeftForm = li_Left
            Quot_Customer_View.mi_TopForm = li_top
            Quot_Customer_View.show
            gl_OldHwndQuotationCustomerView = SetOwner(Quot_Customer_View.hwnd, frmMain.QuotationOutLine.l_FormHandle)
        Case 4
            Quot_SalesProject_View.mi_LeftForm = li_Left
            Quot_SalesProject_View.mi_TopForm = li_top
            Quot_SalesProject_View.show
            gl_OldHwndQuotationSalesProjectView = SetOwner(Quot_SalesProject_View.hwnd, frmMain.QuotationOutLine.l_FormHandle)
    End Select
Err_UnLoad:
End Sub


'------------------------------------------------------------------
' Name : Quotation_ReadSalesRep
'
' Purpose : This procedure load the salesRep code and description
'           respectively in a collection and a Listbox. The code and
'           version of the quotation are in parameter, because it can
'           be change (create a new version for example)
'
' Parameters :
'       ls_QuotationCode          Quotation Code
'       ls_QuotationVersion       Quotation version
'       lo_SalesRepCode           SalesReps Code Collection
'       lo_SalesRepDesc           SalesReps Description ListBox
'
' Return :
'       OK  There was no problem
'       KO  There was a problem
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_ReadSalesRep(ByVal ls_QuotationCode As String, ByVal li_QuotationVersion As Integer, lo_SalesRepCode As Collection, lo_SalesRepDesc As ListBox) As Boolean
Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim i As Integer

    Quotation_ReadSalesRep = KO
    
    On Error GoTo Quotation_ReadSalesRep_Err
    
    'We remove all actual items
    For i = lo_SalesRepCode.Count To 1 Step -1
        lo_SalesRepCode.Remove i
    Next
    lo_SalesRepDesc.Clear
    
    ls_Req = "exec quot_salesReps_lst " & ls_QuotationCode & "," & CStr(li_QuotationVersion) & ",'E'"
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        'Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                lo_SalesRepCode.Add ODBCData(ll_Statement, 1)
                lo_SalesRepDesc.AddItem ODBCData(ll_Statement, 2)
            End If
        Loop
        Quotation_ReadSalesRep = OK
    
        lo_SalesRepDesc.Tag = Loaded
    End If
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

    Exit Function

Quotation_ReadSalesRep_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    
End Function

'------------------------------------------------------------------
' Name : Quotation_Status_Load
'
' Purpose : Load all the status for the quotation system in all language
'
' Parameters : Nothing
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Private Sub Quotation_Status_Load()
Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim i As Integer

    On Error GoTo Quotation_Status_Load_Err
    
    'We remove all actual items
    For i = mo_StatusListCode.Count To 1 Step -1
        mo_StatusListCode.Remove i
        mo_StatusListLang.Remove i
        mo_StatusListDesc.Remove i
    Next
    
    'Execute the stored procedure to read the status for the quotation system
    ls_Req = "exec Document_Status_lst " & QUOTATION_SYSTEM_CODE
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        'Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                'Add the status in the collections
                mo_StatusListCode.Add ODBCData(ll_Statement, 1)
                mo_StatusListLang.Add ODBCData(ll_Statement, 2)
                mo_StatusListDesc.Add ODBCData(ll_Statement, 3)
                mo_StatusListAltDesc.Add ODBCData(ll_Statement, 4)
            End If
        Loop
    End If
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

    Exit Sub

Quotation_Status_Load_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    
End Sub

'------------------------------------------------------------------
' Name : Quotation_Status_Desc
'
' Purpose : Return the description of a status code in an indicate language.
'       This procedure call the Quotation_Status_Load procedure to load the
'       status list only if the status hav'nt be loaded.
'
' Parameters :
'       li_StatusCode     Code of the status
'       ls_LanguageCode   Code of the language
'
' Return :
'       The status description in the good language
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_Status_Desc(li_StatusCode As Integer, ls_LanguageCode As String) As String
Dim li_Position As Integer
Dim i As Integer

    'Load the status list, if they hav'nt be loaded
    If mb_StatusListLoaded <> OK Then
        Quotation_Status_Load
    End If
    
    li_Position = -1
    
    'Find the good status in the collection
    For i = 1 To mo_StatusListCode.Count
        If mo_StatusListCode.Item(i) = li_StatusCode And mo_StatusListLang.Item(i) = ls_LanguageCode Then
            li_Position = i
            Exit For
        End If
    Next
    
    'Return the good description or nothing
    If li_Position > 0 Then
        Quotation_Status_Desc = mo_StatusListDesc.Item(li_Position)
    Else
        Quotation_Status_Desc = ""
    End If
    
End Function

'------------------------------------------------------------------
' Name : Quotation_Status_AltDesc
'
' Purpose : Return the alternative description of a status code
'       in an indicate language. This procedure call the
'       Quotation_Status_Load procedure to load the
'       status list only if the status hav'nt be loaded.
'
' Parameters :
'       li_StatusCode     Code of the status
'       ls_LanguageCode   Code of the language
'
' Return :
'       The alternative status description in the good language
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_Status_AltDesc(li_StatusCode As Integer, ls_LanguageCode As String) As String
Dim li_Position As Integer
Dim i As Integer

    'Load the status list, if they hav'nt be loaded
    If mb_StatusListLoaded <> OK Then
        Quotation_Status_Load
        mb_StatusListLoaded = OK
    End If
    
    li_Position = -1
    
    'Find the good status in the collection
    For i = 1 To mo_StatusListCode.Count
        If mo_StatusListCode.Item(i) = li_StatusCode And mo_StatusListLang.Item(i) = ls_LanguageCode Then
            li_Position = i
            Exit For
        End If
    Next
    
    'Return the good description or nothing
    If li_Position > 0 Then
        Quotation_Status_AltDesc = mo_StatusListAltDesc.Item(li_Position)
    Else
        Quotation_Status_AltDesc = ""
    End If
    
End Function

'------------------------------------------------------------------
' Name : Quotation_NextStatus_Load
'
' Purpose : Load all the next status for all status
'
' Parameters : Nothing
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Private Sub Quotation_NextStatus_Load()
Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim i As Integer

    On Error GoTo Quotation_NextStatus_Load_Err
    
    'We remove all actual items
    For i = mo_NextStatusListCodeParent.Count To 1 Step -1
        mo_NextStatusListCodeParent.Remove i
        mo_NextStatusListCodeChild.Remove i
    Next
    
    'Execute the stored procedure to read the status for the quotation system
    ls_Req = "exec Document_NextStatus_lst " & QUOTATION_SYSTEM_CODE
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        'Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                'Add the status in the collections
                mo_NextStatusListCodeParent.Add ODBCData(ll_Statement, 1)
                mo_NextStatusListCodeChild.Add ODBCData(ll_Statement, 2)
            End If
        Loop
    End If
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

    Exit Sub

Quotation_NextStatus_Load_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    
End Sub

'------------------------------------------------------------------
' Name : Quotation_NextStatusList
'
' Purpose : Return the list of the possible status code after the
'           actual status of the quotation
'
' Parameters :
'       li_StatusCode     Code of the status
'
' Return :
'       The list of the next status code possible after this
'
' review : Oct/27/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_NextStatusList(li_StatusCode As Integer) As Collection
Dim li_Position As Integer
Dim i As Integer
Dim lo_list As New Collection

    'Load the next status list, if they hav'nt be loaded
    If mb_NextStatusListLoaded <> OK Then
        Quotation_NextStatus_Load
    End If
    
    'Find the good status in the collection
    For i = 1 To mo_NextStatusListCodeParent.Count
        If mo_NextStatusListCodeParent.Item(i) = li_StatusCode Then
            'The parent is good, so we can add the child to the list
            lo_list.Add mo_NextStatusListCodeChild.Item(i)
        End If
    Next
    
    Set Quotation_NextStatusList = lo_list
    
End Function

'------------------------------------------------------------------
' Name : Quotation_Historic
'
' Purpose :  Display the history of a quotation
'
' Parameters : nothing
'
' review : Oct/28/1999 by JC
'------------------------------------------------------------------
Public Sub Quotation_Historic()
Dim li_Count As Integer
Dim ls_OldTableName As String

    MouseOff
    ls_OldTableName = gs_TableName
    gs_TableName = "Quot_Historic"
    gi_GridWidth(0) = 1000
    gi_GridWidth(1) = 800
    gi_GridWidth(2) = 4000
    gi_GridWidth(3) = 3100
    For li_Count = 4 To 29
        gi_GridWidth(li_Count) = 1
    Next li_Count
    gs_ParamReq1 = "EXEC quot_documentstatus_sel " & gi_QuotationCode & ",'"
    gs_ParamReq2 = "EXEC Screen_Csts 'quot_historic','" & gut_LangLogin.Code & "'"
    gs_ParamReq3 = "EXEC Check_Security 'quot_historic', '" & prg.LoginName & "'"
    C_main.show 1
    gs_TableName = ls_OldTableName
    MouseOn
End Sub

'------------------------------------------------------------------
' Name : Quotation_AddNew
'
' Purpose : Call the update screen, initialize parameters and update
'           the user view at the end
'
' Parameters :
'       li_left        Left position for the view
'       li_top         Top position for the view
'
'
' review : Nov/5/1999 by AD
'------------------------------------------------------------------
Sub Quotation_AddNew(li_Left As Integer, li_top As Integer)
Dim i As Integer

    On Error GoTo AddQuotation_Err
    
    Quot_General_mtnc.mi_Action = QA_New

    'We consider that the salesrep list is loaded for a new quotation !
    Quot_General_mtnc.mb_SalesRepLoaded = OK
    For i = Quot_General_mtnc.mo_SalesRepCode.Count To 1 Step -1
        Quot_General_mtnc.mo_SalesRepCode.Remove i
    Next
    For i = Quot_General_mtnc.mo_SalesRepDesc.Count To 1 Step -1
        Quot_General_mtnc.mo_SalesRepDesc.Remove i
    Next
    
    'All the informations for a new quotation are filled by the Quotation_General Form
    'We make this, only to verify that in the other case, all the information have been filled
    Quot_General_mtnc.mi_iConcurrency = 0
    
    Quot_General_mtnc.ml_TotalSurface = 0
    Quot_General_mtnc.mr_TotalAmount = 0
    Quot_General_mtnc.mr_LeadTime = 0
    
    Quot_General_mtnc.ms_LanguageCode = 0
    Quot_General_mtnc.ms_LanguageDesc = ""
    Quot_General_mtnc.ml_ClaimCustomerCode = 0
    Quot_General_mtnc.ms_ClaimCustomerDesc = ""
    Quot_General_mtnc.mi_DeliveryAddressCode = 0
    Quot_General_mtnc.ms_DeliveryAddressDesc = ""
    Quot_General_mtnc.ms_PlantCode = 0
    Quot_General_mtnc.ms_PlantDesc = ""
    Quot_General_mtnc.ml_SalesProjectCode = 0
    Quot_General_mtnc.ms_SalesProjectDesc = ""
    Quot_General_mtnc.ms_SalesOfficeCode = 0
    Quot_General_mtnc.ms_SalesOfficeDesc = ""
    Quot_General_mtnc.ms_CurrencyCode = 0
    Quot_General_mtnc.ms_currencyDesc = ""
    Quot_General_mtnc.mi_QuotationCode = 0
    Quot_General_mtnc.ms_QuotationDesc = ""
    Quot_General_mtnc.mi_QuotationVersion = 0
    Quot_General_mtnc.mi_QuotationStatusCode = Quotation_Status.None
    Quot_General_mtnc.mi_QuotationStatusDesc = Quotation_Status_Desc(Quotation_Status.None, "E")
    Quot_General_mtnc.ms_Creator = ""
    Quot_General_mtnc.ms_Approval = ""
    Quot_General_mtnc.ms_DeliveryDate = ""
    Quot_General_mtnc.ms_ValidityDate = ""
    Quot_General_mtnc.ms_ApprovalDate = ""
    Quot_General_mtnc.ms_InternetFlag = KO
    Quot_General_mtnc.ms_DropDate = ""
    
    Quot_General_mtnc.ms_SAPOrder = ""
    Quot_General_mtnc.mi_LoseReasonCode = 0
    Quot_General_mtnc.ms_LoseReasonDesc = ""

    Quot_General_mtnc.show 1
    
    If Quot_General_mtnc.mb_Return = OK Then
        'Quotation_Change Quot_General_mtnc.mi_QuotationCode, Quot_General_mtnc.ms_QuotationDesc, li_Left, li_top, 2
        mi_View = 2
        'FrmMain.QuotationOutLine.SearchOutline Quot_General_mtnc.mi_QuotationCode
        frmMain.QuotationOutLine.LocalAddItem Quot_General_mtnc.mi_QuotationCode, Quot_General_mtnc.ms_QuotationDesc
    End If
    
    Exit Sub
    
AddQuotation_Err:
    StdError

End Sub

'------------------------------------------------------------------
' Name : Quotation_ChangeStatus
'
' Purpose : Chenge the status of a version
'
' Parameters :
'       li_quotationCode    Code of the quotation
'       li_version          Version of the quotation
'       li_status           The new status of the quotation
'
' review : Nov/5/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_ChangeStatus(li_QuotationCode As Integer, li_version As Integer, li_Status As Integer) As Boolean
Dim ls_Req As String
Dim ll_Statement As Long

    Quotation_ChangeStatus = KO

    On Error GoTo Quotation_ChangeStatus_Err

    ls_Req = "exec Quot_DocumentStatus_ins " & CStr(li_QuotationCode) & "," & CStr(li_version) & "," & CStr(li_Status)
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        Quotation_ChangeStatus = OK
    End If
    SQLFreeStatement ll_Statement, SQL_DROP

    Exit Function

Quotation_ChangeStatus_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
End Function

'------------------------------------------------------------------
' Name : Quotation_DeleteStatus
'
' Purpose : Delete the status of a version
'
' Parameters :
'       li_quotationCode    Code of the quotation
'       li_version          Version of the quotation
'       li_status           Status to delete
'
' review : Nov/5/1999 by AD
'------------------------------------------------------------------
Public Function Quotation_DeleteStatus(li_QuotationCode As Integer, li_version As Integer, li_Status As Integer) As Boolean
Dim ls_Req As String
Dim ll_Statement As Long

    Quotation_DeleteStatus = KO

    On Error GoTo Quotation_DeleteStatus_Err

    ls_Req = "exec Quot_DocumentStatus_del " & CStr(li_QuotationCode) & "," & CStr(li_version) & "," & CStr(li_Status)
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        Quotation_DeleteStatus = OK
    End If
    SQLFreeStatement ll_Statement, SQL_DROP

    Exit Function

Quotation_DeleteStatus_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
End Function

